#pragma once

#include <xtable/xtable.h>
#include <yxiva/core/types.h>
#include <tuple>

namespace yxiva { namespace hub { namespace xtable { namespace resharding {

enum class query_type
{
    subscribe,
    subscribe_mobile,
    unsubscribe,
    unsubscribe_mobile,
    unsubscribe_overlapped,
    batch_unsubscribe,
    update,
    update_uidset,
    update_callback
};

string query_type_to_string(query_type t);
query_type query_type_from_string(const string& s);

struct subscribe_traits
{
    using params = std::tuple<sub_t>;
    using cb_params = std::tuple<sub_t>;

    static constexpr query_type get_type()
    {
        return query_type::subscribe;
    }
    static constexpr decltype(&XTable::subscribe) method()
    {
        return &XTable::subscribe;
    }
};

struct subscribe_mobile_traits
{
    using params = std::tuple<
        string,
        string,
        filter_t,
        string,
        string,
        string,
        string,
        ttl_t,
        string,
        local_id_t,
        string,
        string,
        string>;
    using cb_params = std::tuple<sub_t>;

    static constexpr query_type get_type()
    {
        return query_type::subscribe_mobile;
    }
    static constexpr decltype(&XTable::subscribe_mobile) method()
    {
        return &XTable::subscribe_mobile;
    }
};

struct unsubscribe_traits
{
    using params = std::tuple<string, string, string>;
    using cb_params = std::tuple<string>;

    static constexpr query_type get_type()
    {
        return query_type::unsubscribe;
    }
    static constexpr decltype(&XTable::unsubscribe) method()
    {
        return &XTable::unsubscribe;
    }
};

struct unsubscribe_mobile_traits
{
    using params = std::tuple<string, string, string>;
    using cb_params = std::tuple<string>;

    static constexpr query_type get_type()
    {
        return query_type::unsubscribe_mobile;
    }
    static constexpr decltype(&XTable::unsubscribe_mobile) method()
    {
        return &XTable::unsubscribe_mobile;
    }
};

struct unsubscribe_overlapped_traits
{
    using params = std::tuple<string, string, string, unsigned>;
    using cb_params = std::tuple<string>;

    static constexpr query_type get_type()
    {
        return query_type::unsubscribe_overlapped;
    }
    static constexpr decltype(&XTable::unsubscribe_overlapped) method()
    {
        return &XTable::unsubscribe_overlapped;
    }
};

struct batch_unsubscribe_traits
{
    using params = std::tuple<string, string, std::vector<string>, std::time_t>;
    using cb_params = std::tuple<std::vector<string>>;

    static constexpr query_type get_type()
    {
        return query_type::batch_unsubscribe;
    }
    static constexpr decltype(&XTable::batch_unsubscribe) method()
    {
        return &XTable::batch_unsubscribe;
    }
};

struct update_traits
{
    using params = std::tuple<string, string, string, local_id_t, local_id_t, time_t, time_t>;
    using cb_params = std::tuple<bool, local_id_t>;

    static constexpr query_type get_type()
    {
        return query_type::update;
    }
    static constexpr decltype(&XTable::update) method()
    {
        return &XTable::update;
    }
};

struct update_uidset_traits
{
    using params = std::tuple<string, string, string, string>;
    using cb_params = std::tuple<>;

    static constexpr query_type get_type()
    {
        return query_type::update_uidset;
    }
    static constexpr decltype(&XTable::update_uidset) method()
    {
        return &XTable::update_uidset;
    }
};

struct update_callback_traits
{
    using params = std::tuple<string, string, string, string, string>;
    using cb_params = std::tuple<>;

    static constexpr query_type get_type()
    {
        return query_type::update_callback;
    }
    static constexpr decltype(&XTable::update_callback) method()
    {
        return &XTable::update_callback;
    }
};

template <typename CallbackParams>
struct response_body
{
    int ec_value;
    std::decay_t<CallbackParams> params;

    MSGPACK_DEFINE(ec_value, params);
};

template <typename Callback>
struct ec_binder
{
    error_code ec;
    std::decay_t<Callback> cb;

    template <typename... Args>
    void operator()(Args&&... args)
    {
        cb(ec, std::forward<Args>(args)...);
    }
};

}}}}
