#pragma once

#include <boost/uuid/string_generator.hpp>
#include <boost/uuid/uuid_io.hpp>
#include <boost/system/error_code.hpp>

#include <yxiva/core/iabstract.h>
#include <yxiva/core/types.h>
#include <yxiva/core/services/decoder_interface.h>
#include <yxiva/core/shards/storage.h>
#include <yplatform/module.h>
#include <yplatform/hash/sha1.h>

#include "istorage.h"
#include "../error.h"

namespace yxiva { namespace hub {

typedef std::function<void(const error_code&, const sub_t&)> subscribe_callback_t;
typedef std::function<void(const error_code&, const string&)> callback_t;

class XTable : public iabstract
{
public:
    using db_role = IStorage::db_role;
    struct find_options
    {
        bool show_inactive = false;
        db_role db_role = db_role::master;
    };

    virtual void force_db_role(std::optional<db_role>) = 0;
    virtual void subscribe(
        task_context_ptr ctx,
        const sub_t& subscription,
        const subscribe_callback_t& callback) = 0;
    virtual void subscribe_mobile(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const filter_t& filter,
        const string& callback_url,
        const string& extra_data,
        const string& client,
        const string& device_uuid,
        const ttl_t ttl,
        const string& subscription_id,
        const local_id_t init_local_id,
        const string& platform,
        const string& device,
        const string& bb_connection_id,
        const subscribe_callback_t& callback) = 0;
    virtual void unsubscribe(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const string& subscription_id,
        const callback_t& callback) = 0;
    virtual void unsubscribe_mobile(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const string& device_uuid,
        const callback_t& callback) = 0;
    virtual void unsubscribe_overlapped(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const string& subscription_id,
        const unsigned overlap_sec,
        const callback_t& callback) = 0;
    virtual void batch_unsubscribe(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const std::vector<string>& subscription_ids,
        std::time_t init_not_after,
        const batch_del_callback_t& callback) = 0;
    virtual void find(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const find_options& options,
        const find_callback_t& callback) = 0;
    virtual void batch_find(
        task_context_ptr ctx,
        const batch_keys& keys,
        const string& service,
        const find_options& options,
        const batch_find_callback_t& callback) = 0;
    virtual void update(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const string& subscription_id,
        local_id_t old_local_id,
        local_id_t new_local_id,
        time_t retry_interval,
        time_t ack_event_ts,
        const update_callback_t& callback) = 0;
    virtual void add_broken_subscription(
        task_context_ptr ctx,
        const string& platform,
        const string& subscription_id,
        std::time_t timestamp,
        const add_callback_t& callback) = 0;
    virtual void find_uidset(
        task_context_ptr ctx,
        const string& uidset,
        const string& service,
        const find_options& options,
        const find_callback_t& callback) = 0;
    virtual void update_uidset(
        task_context_ptr ctx,
        const string& uidset,
        const string& service,
        const string& old_cb,
        const string& new_cb,
        const update_uidset_callback_t& callback) = 0;
    virtual void update_callback(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const string& subscription_id,
        const string& old_cb,
        const string& new_cb,
        const update_uidset_callback_t& callback) = 0;
    virtual void batch_find(
        task_context_ptr ctx,
        const string& uid,
        const std::vector<string>& services,
        const find_options& options,
        const find_callback_t& callback) = 0;
    virtual std::shared_ptr<shard_config::storage> shards() = 0;
    virtual void enable_fallback(task_context_ptr ctx) = 0;
    virtual void disable_fallback(task_context_ptr ctx) = 0;
};

typedef boost::shared_ptr<XTable> xtable_ptr;

}}
