#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"
LOGFILE="/var/log/$QLOUD_APPLICATION/$QLOUD_APPLICATION.log"
ts=$(date +%s)

timetail -n 60 -t imap "$LOGFILE" | head -n -1 | \
    awk -v ts="$ts" '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    /processing_error/ {
        step = ""
        reason = ""

        for (i=1; i <= NF; i++) {
            if ($i ~ /^step=/) {
                step = substr($i, 6)
            } else if ($i ~ /^reason=/) {
                reason = substr($i, 8)
            }
        }

        if (reason != "" && step != "") metrics["errors.by_step."step"."reason]++
    }

    END {
        for (i in metrics) {
            print i, metrics[i], ts
        }
    }
' | awk '
    match($1,/tier_/) {
        tier = substr($1, RSTART+RLENGTH)
        if (tier == "") tier = "none"
        print substr($1,1,RSTART-2), $2, $3, tier
    }
    !/tier_/ {
        print
    }
'
