#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"
LOGFILE="/var/log/$QLOUD_APPLICATION/typed.log"
ts=$(date +%s)

timetail -n 60 -r '^tskv	tskv_format=mailpusher-log	timestamp=.{11}(\d\d:\d\d:\d\d)' "$LOGFILE" | head -n -1 | \
    awk -F $'\t' -v ts="$ts" '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    /status=/ {
        status = ""
        reason = ""
        action = ""
        db = ""

        for (i=1; i <= NF; i++) {
            if ($i ~ /^status=/) {
                status = substr($i, 8)
            } else if ($i ~ /^reason=/) {
                reason = substr($i, 8)
                gsub(" ","_",reason)
            } else if ($i ~ /^action=/) {
                action = substr($i, 8)
            } else if ($i ~ /^dbname=/) {
                db = substr($i, 8)
            }
        }

        for (i=1; i <= NF; i++) {
            if ($i ~ /^profiler_/) {
                split($i, splitted, "=")
                prof=substr(splitted[1], 10)
                timing=splitted[2]
                collect_timings(timing, "events.timings.total."prof, metrics)
                collect_timings(timing, "events.timings.by_action."action"."prof, metrics)
            }
        }

        metrics["events.total."status]++
        metrics["events.by_action."action".total"]++
        metrics["events.by_action_status."action"."status]++
        if (reason != "") {
            metrics["events.by_reason.total."status"."reason]++
            metrics["events.by_action_reason."action"."status"."reason]++
        }
    }

    END {
        for (i in metrics) {
            value = metrics[i]
            if (i ~ /timings/) value = "["value"]"
            print i, value, ts
        }
    }
' | awk '
    match($1,/tier_/) {
        tier = substr($1, RSTART+RLENGTH)
        if (tier == "") tier = "none"
        print substr($1,1,RSTART-2), $2, $3, tier
    }
    !/tier_/ {
        print
    }
'
