#pragma once

#include <mailpusher/fid_counters.h>
#include <mailpusher/fetch_status.h>
#include <mailpusher/types.h>
#include <boost/logic/tribool.hpp>

namespace yxiva::mailpusher {

struct account
{
    string uid;
    string environment;
    std::vector<uint64_t> exfid;
    boost::logic::tribool has_subscriptions;
    // True when badge is enabled for this account in app settings.
    bool badge_enabled = false;
    std::vector<fid_counters> fids_counters;
    fetch_status counters_fetched = fetch_status::NONE;
};

}