#pragma once

#include <mailpusher/types.h>
#include <map>

namespace yxiva::mailpusher {

enum action
{
    UNKNOWN = 0,
    NEW_MAIL,
    MOVE_MAILS,
    MOVE_MAILS2,
    DELETE_MAILS,
    COPY_MAILS,
    MARK_MAILS,
    UNMARK_MAILS,
    CHANGE_STATUS,
    USER_UPDATE,
    RESET_FRESH,
    TRANSFER,

    COUNT
};

static const string action_names[action::COUNT] = {
    "unknown", "store",  "move",   "move2", "delete", "copy",
    "mark",    "unmark", "status", "user",  "reset",  "transfer",
};

inline const string& get_action_name(action a)
{
    return action_names[a];
}

inline action resolve_action(const string& name)
{
    static const std::map<string, action> actions_by_name{
        { action_names[NEW_MAIL], NEW_MAIL },
        { action_names[MOVE_MAILS], MOVE_MAILS },
        { action_names[MOVE_MAILS2], MOVE_MAILS2 },
        { action_names[DELETE_MAILS], DELETE_MAILS },
        { action_names[COPY_MAILS], COPY_MAILS },
        { action_names[MARK_MAILS], MARK_MAILS },
        { action_names[UNMARK_MAILS], UNMARK_MAILS },
        { action_names[CHANGE_STATUS], CHANGE_STATUS },
        { action_names[USER_UPDATE], USER_UPDATE },
        { action_names[RESET_FRESH], RESET_FRESH },
        { action_names[TRANSFER], TRANSFER }
    };
    auto it = actions_by_name.find(name);
    return it == actions_by_name.end() ? action::UNKNOWN : it->second;
}

}
