#pragma once

#include <mailpusher/action.h>
#include <mailpusher/fetch_status.h>
#include <mailpusher/types.h>
#include <yxiva/core/user_info.h>
#include <yxiva/core/json.h>
#include <ctime>

namespace yxiva::mailpusher {

struct event
{
    string uid;
    string suid;

    size_t change_id;

    string lcn;
    action action_type;
    string x_request_id;
    time_t ts;

    std::vector<json_value> items;
    json_value args;

    // Count of items members for which metadata is fetched (or skipped).
    size_t metadata_count = 0;
    // Flag indicationg there were problems processing this event
    // and it should be skipped.
    bool skip = false;
    // Flag indicating that avatar is fetched or skipped.
    fetch_status avatar_fetched = fetch_status::NONE;
    // Xiva-server response context-id and transit-id.
    string xiva_context;
    string xiva_transit;
    // IDs of notifications sent on the previous try.
    std::vector<string> sent_notification_ids;

    auto lag() const
    {
        return std::time(nullptr) - ts;
    }
};

}
