#pragma once

#include <mailpusher/types.h>
#include <map>

namespace yxiva::mailpusher {

enum class fetch_status
{
    NONE,
    FETCHED,
    FAILED,
    SKIPPED,
    MISSING
};

inline const string& get_status_name(fetch_status status)
{
    static const string NONE = "none";
    static const string FETCHED = "fetched";
    static const string FAILED = "failed";
    static const string SKIPPED = "skipped";
    static const string MISSING = "missing";
    static const string UNKNOWN = "unknown";

    switch (status)
    {
    case fetch_status::NONE:
        return NONE;
    case fetch_status::FETCHED:
        return FETCHED;
    case fetch_status::FAILED:
        return FAILED;
    case fetch_status::SKIPPED:
        return SKIPPED;
    case fetch_status::MISSING:
        return MISSING;
    default:
        return UNKNOWN;
    }
}

}
