#pragma once

#include <mailpusher/task.h>
#include <mailpusher/event.h>
#include <yxiva/core/json.h>
#include <set>
#include <map>
#include <vector>

namespace yxiva::mailpusher {

struct destination
{
    std::set<string> transport;
    std::set<string> platform;
    std::set<string> subscription_id;
};

inline bool operator==(const destination& lhs, const destination& rhs)
{
    return lhs.transport == rhs.transport && lhs.platform == rhs.platform &&
        lhs.subscription_id == rhs.subscription_id;
}

struct notification
{
    enum class delivery_mode
    {
        queued,
        direct
    };

    // Unique within a single event.
    string id;
    struct destination destination;
    delivery_mode delivery;
    bool silent;
    json_value body;
    json_value keys;
    json_value repack = {};

    string operation() const
    {
        return get_value("operation", "operation");
    }

    string session_key() const
    {
        return get_value("session_key", "sessionKey");
    }

private:
    string get_value(const char* key_name, const char* body_name) const
    {
        string value = json_get<string>(keys, key_name, "");
        return value.empty() ? json_get<string>(body, body_name, "") : value;
    }
};

}
