#pragma once

#include <mailpusher/device.h>
#include <mailpusher/event.h>
#include <mailpusher/types.h>
#include <mailpusher/fid_counters.h>
#include <mailpusher/subscription.h>
#include <yplatform/task_context.h>
#include <vector>
#include <memory>

namespace yxiva::mailpusher {

struct task : yplatform::task_context
{
    task(const yplatform::task_context& other)
        : yplatform::task_context(other), profilers(uniq_id())
    {
    }

    string uid;
    string suid;
    string db;
    std::vector<event> events;
    std::vector<subscription> subscriptions;
    size_t processed = 0;
    fetch_status counters_fetched = fetch_status::NONE;
    std::vector<fid_counters> counters;
    prof_accumulator profilers{ "test" }; // Default id for tests
    std::unordered_map<string, device> devices;

    string sup_id;

    inline auto& next_unprocessed_event()
    {
        return events.at(processed);
    }
};

}
