#include "batch_push.h"
#include "json_helpers.h"
#include "module.h"
#include <mailpusher/event.h>
#include <mailpusher/task.h>
#include <mailpusher/types.h>
#include <yxiva/core/json.h>
#include <yplatform/find.h>

namespace yxiva::mailpusher {
namespace {
int to_http_code(const error_code& ec)
{
    switch (ec.value())
    {
    case error::success:
        return 200;
    case error::uninitialized_user:
        return 205;
    case error::rate_limit:
        return 429;
    case error::bad_gateway:
        return 502;
    case error::task_cancelled:
        return 504;
    case error::remote_bad_request:
    case error::internal_error:
    case error::network_error:
    default:
        return 500; // Unknown error code.
    }
}
}

void batch_push::operator()(ymod_webserver::http::stream_ptr stream)
{
    auto& raw_body = stream->request()->raw_body;
    // TODO Introduce deadline delta to answer in time?
    auto task = make_shared<::yxiva::mailpusher::task>(*stream->ctx());
    if (auto parse_res = parse_task(*task, string(raw_body.begin(), raw_body.end())); !parse_res)
    {
        YLOG_CTX_GLOBAL(stream->ctx(), info)
            << "failed to parse json, error: \"" << parse_res.error_reason << "\"";
        stream->result(ymod_webserver::codes::bad_request, parse_res.error_reason);
        return;
    }

    yplatform::find<module>("processor")->process_task(task, [stream, task](const error_code& ec) {
        json_value resp;
        resp["result"] = dump_task(*task);
        resp["code"] = to_http_code(ec);
        if (ec) resp["error"] = ec.message();
        stream->ctx()->custom_log_data["result_code"] = std::to_string(to_http_code(ec));
        stream->ctx()->custom_log_data["result_message"] = ec.message();
        stream->ctx()->custom_log_data["processed"] = std::to_string(task->processed);
        stream->ctx()->custom_log_data["sup_id"] = task->sup_id;

        stream->set_code(ymod_webserver::codes::ok);
        stream->set_content_type("application/json");
        stream->result_body(json_write(resp));
    });
}

}
