#pragma once

#include <yxiva/core/json.h>

namespace yxiva::mailpusher {

inline void join_address_with_display_name(
    std::ostream& os,
    const string& display_name,
    const string& local,
    const string& domain)
{
    os << "\"" << display_name << "\" <" << local << "@" << domain << ">";
}

inline string join_json_addresses(const json_value& addresses, const char* separator = ", ")
{
    std::stringstream ss;
    if (addresses.type() == json_type::tarray)
    {
        for (size_t i = 0; i < addresses.size(); i++)
        {
            const json_value& address = addresses[i];
            if (address.type() == json_type::tobject)
            {
                if (i > 0) ss << separator;
                join_address_with_display_name(
                    ss,
                    json_decoder<string>::get(address["displayName"], ""),
                    json_decoder<string>::get(address["local"], ""),
                    json_decoder<string>::get(address["domain"], ""));
            }
        }
    }
    return ss.str();
}

}
