#pragma once

#include <yxiva/core/json.h>

namespace yxiva::mailpusher {

inline string format_received_date(const json_value& value)
{
    int raw_ts = json_decoder<int>::get(value, -1);
    if (raw_ts < 0) return "";

    std::time_t ts = static_cast<std::time_t>(raw_ts);
    char tmpstr[100];
    std::strftime(tmpstr, sizeof(tmpstr), "%d.%m.%Y %H:%M:%S", std::localtime(&ts));
    return tmpstr;
}

}
