#pragma once

#include <mailpusher/notification.h>
#include <yxiva/core/platforms.h>

namespace yxiva::mailpusher {

static const string SUBSCRIPTION_ID_PLACEHOLDER = "%subscription_id%";

static const auto DESTINATION_EXCEPT_MOBILE =
    destination{ { "http", "webpush", "websocket" }, {}, {} };
static const auto DESTINATION_MOBILE = destination{ { "mobile" }, {}, {} };
static const auto DESTINATION_ANDROID =
    destination{ { "mobile" }, { platform::FCM, platform::HMS }, {} };
static const auto DESTINATION_APNS = destination{ { "mobile" }, { platform::APNS }, {} };
static const auto DESTINATION_APNS_SUBSCRIPTION =
    destination{ { "mobile" }, { platform::APNS }, { SUBSCRIPTION_ID_PLACEHOLDER } };

}
