#pragma once

#include <yxiva/core/json.h>

namespace yxiva::mailpusher {

inline int extract_folder_code(const json_value_ref& vals)
{
    const auto UNKNOWN = 0;
    if (vals.type() == json_type::tobject)
    {
        auto&& type_info = vals["symbolicName"];
        if (type_info.type() == json_type::tobject)
        {
            return json_decoder<int>::get(type_info["code"], UNKNOWN);
        }
    }
    return UNKNOWN;
}

}
