#pragma once

#include <yxiva/core/json.h>

namespace yxiva::mailpusher {

inline json_value extract_labels_from_args(
    const json_value& args,
    const char* basic_array,
    bool equals_to)
{
    static const std::map<string, string> flags = {
        { "seen", "FAKE_SEEN_LBL" },
        { "recent", "FAKE_RECENT_LBL" },
        { "deleted", "FAKE_DELETED_LBL" },
    };

    json_value labels(json_type::tarray);

    if (!args.has_member(basic_array) || args[basic_array].type() != json_type::tarray)
        return labels;

    for (auto&& lid : args[basic_array].array_items())
        labels.push_back(json_decoder<string>::get(lid, ""));

    for (auto&& flag : flags)
    {
        if (json_decoder<bool>::get(args[flag.first], !equals_to) == equals_to)
        {
            labels.push_back(flag.second);
        }
    }

    return labels;
}

inline json_value status_from_flags(bool seen, bool forwarded, bool answered)
{
    if (seen)
    {
        if (forwarded)
        {
            return "PL";
        }
        else if (answered)
        {
            return "OQ";
        }
        return "RO";
    }
    return "New";
}

inline json_value status_from_is_mixed(uint64_t is_mixed)
{
    const int SEEN_BIT = 2048;
    const int FORWARDED_BIT = 512;
    const int ANSWERED_BIT = 1024;
    return status_from_flags(
        SEEN_BIT & is_mixed, FORWARDED_BIT & is_mixed, ANSWERED_BIT & is_mixed);
}

}
