#pragma once

#include "field.h"

namespace yxiva::mailpusher {

inline const char* xiva_operation_name(action action)
{
    switch (action)
    {
    case NEW_MAIL:
        return "insert";
    case MOVE_MAILS:
        return "move mails";
    case MOVE_MAILS2:
        return "move mails";
    case COPY_MAILS:
        return "copy mails";
    case DELETE_MAILS:
        return "delete mails";
    case MARK_MAILS:
        return "mark mails";
    case UNMARK_MAILS:
        return "unmark mails";
    case CHANGE_STATUS:
        return "status change";
    case RESET_FRESH:
        return "reset fresh";
    case TRANSFER:
        return "transfer";
    default:
        return "unsupported";
    }
};

inline auto get_operation(const field::context& ctx)
{
    return xiva_operation_name(ctx.event.action_type);
}

inline auto get_uid(const field::context& ctx)
{
    return ctx.event.uid;
}

inline auto get_suid(const field::context& ctx)
{
    return ctx.event.suid;
}

inline auto get_lcn(const field::context& ctx)
{
    return ctx.event.lcn;
}

inline auto get_ts(const field::context& ctx)
{
    return ctx.event.ts;
}

inline auto get_sound(const field::context& ctx)
{
    static const string default_sound = "p.caf";
    auto& extra = ctx.subscription.common()->extra;
    json_value src_json;
    if (!json_parse(src_json, extra))
    {
        // TODO Purge if mobile app is not being released.
        static const string prefix = "sound.";
        using boost::algorithm::starts_with;
        if (starts_with(extra, prefix))
        {
            return extra.substr(prefix.size());
        }
        return default_sound;
    }
    return json_get(src_json, "sound", default_sound);
}

inline json_value get_badge(const field::context& ctx)
{
    return ctx.event.args["mailpusher_badge"][ctx.subscription.common()->id];
}

inline auto get_ios_version(const field::context& ctx)
{
    auto& client = ctx.subscription.common()->client;
    size_t start = client.rfind("OS_");
    if (start == string::npos)
    {
        return 0;
    }
    start += 3;
    try
    {
        return std::stoi(client.substr(start, client.find("_", start) - start));
    }
    catch (...)
    {
        return 0;
    }
}

inline auto get_collapse_id(const field::context& ctx)
{
    return ctx.event.uid + "_" + ctx.event.lcn;
}

}