#pragma once

#include <yxiva/core/json.h>

namespace yxiva::mailpusher {

inline string join_json(const json_value& json_array, const char* separator = ",")
{
    std::stringstream ss;
    if (json_array.type() == json_type::tarray)
    {
        for (size_t i = 0; i < json_array.size(); i++)
        {
            if (i > 0) ss << separator;
            ss << json_decoder<string>::get(json_array[i], "");
        }
    }
    return ss.str();
}

}
