#pragma once

#include <yxiva/core/json.h>

namespace yxiva::mailpusher {

inline json_value trunc_labels_info(const json_value& body)
{
    json_value labelsInfo(json_type::tobject);
    if (body.is_object())
    {
        for (auto inode = body.members_begin(); inode != body.members_end(); ++inode)
        {
            labelsInfo[string(inode.key())]["symbolicName"]["title"] = json_get(
                json_get(*inode, "symbolicName", json_value(json_type::tobject)),
                "title",
                string());
        }
    }

    return labelsInfo;
}

}
