#include "mappers.h"

#include "address.h"
#include "join_fields.h"
#include "date.h"
#include "flags.h"
#include "extract_folder_code.h"
#include "loc_args.h"
#include "labels_info.h"
#include "notification_mappers.h"

namespace yxiva::mailpusher {

const mappers_collection MAPPERS{
    { NEW_MAIL,
      { INSERT_MAPPERS,
        INSERT_MAPPERS_ANDROID,
        INSERT_MAPPERS_APNS_BRIGHT,
        INSERT_MAPPERS_APNS_SILENT } },
    { MOVE_MAILS,
      { MOVE_COPY_MAILS_MAPPERS, MOVE_COPY_MAILS_MAPPERS_ANDROID, MOVE_COPY_MAILS_MAPPERS_APNS } },
    { MOVE_MAILS2,
      { MOVE_COPY_MAILS_MAPPERS, MOVE_COPY_MAILS_MAPPERS_ANDROID, MOVE_COPY_MAILS_MAPPERS_APNS } },
    { COPY_MAILS,
      { MOVE_COPY_MAILS_MAPPERS, MOVE_COPY_MAILS_MAPPERS_ANDROID, MOVE_COPY_MAILS_MAPPERS_APNS } },
    { DELETE_MAILS,
      { FAKE_MOVE_DELETED_MAILS_MAPPERS,
        FAKE_MOVE_DELETED_MAILS_MAPPERS_ANDROID,
        FAKE_MOVE_DELETED_MAILS_MAPPERS_APNS,
        DELETE_MAILS_MAPPERS } },
    { MARK_MAILS,
      { MARK_UNMARK_MAILS_MAPPERS,
        MARK_UNMARK_MAILS_MAPPERS_ANDROID,
        MARK_UNMARK_MAILS_MAPPERS_APNS,
        UPDATE_LABELS_MAPPERS,
        UPDATE_LABELS_MAPPERS_APNS } },
    { UNMARK_MAILS,
      { MARK_UNMARK_MAILS_MAPPERS,
        MARK_UNMARK_MAILS_MAPPERS_ANDROID,
        MARK_UNMARK_MAILS_MAPPERS_APNS,
        UPDATE_LABELS_MAPPERS,
        UPDATE_LABELS_MAPPERS_APNS } },
    { CHANGE_STATUS,
      {
          STATUS_CHANGE_MAPPERS,
          STATUS_CHANGE_MAPPERS_ANDROID,
          STATUS_CHANGE_MAPPERS_APNS,
          UPDATE_LABELS_STATUS_CHANGE_MAPPERS,
          UPDATE_LABELS_MAPPERS_APNS // Not a mistake. For APNS, mids_str field is unnecessary.
      } },
    { RESET_FRESH, { RESET_FRESH_MAPPERS } },
    { TRANSFER,
      {
          TRANSFER_MAPPERS,
          TRANSFER_MAPPERS_ANDROID,
          TRANSFER_MAPPERS_APNS,
      } },
};

inline auto add_mobile_mappers(const mappers_collection& http_action_mappers)
{
    mappers_collection ret;
    for (auto& [action, http_mappers] : http_action_mappers)
    {
        std::vector<notification_mappers> mappers_with_mobile;
        mappers_with_mobile.reserve(2 * http_mappers.size());
        for (auto& http_mapper : http_mappers)
        {
            mappers_with_mobile.push_back(http_mapper);
            // Duplicate http mapper, but rewrite it's destination
            mappers_with_mobile.push_back(http_mapper);
            mappers_with_mobile.back().destination = DESTINATION_MOBILE;
        }
        ret[action] = std::move(mappers_with_mobile);
    }
    return ret;
}

const mappers_collection PRE_RTEC_3674_MAPPERS = add_mobile_mappers({
    { NEW_MAIL, { INSERT_MAPPERS } },
    { MOVE_MAILS, { MOVE_COPY_MAILS_MAPPERS } },
    { MOVE_MAILS2, { MOVE_COPY_MAILS_MAPPERS } },
    { COPY_MAILS, { MOVE_COPY_MAILS_MAPPERS } },
    { DELETE_MAILS, { FAKE_MOVE_DELETED_MAILS_MAPPERS, DELETE_MAILS_MAPPERS } },
    { MARK_MAILS, { MARK_UNMARK_MAILS_MAPPERS, UPDATE_LABELS_MAPPERS } },
    { UNMARK_MAILS, { MARK_UNMARK_MAILS_MAPPERS, UPDATE_LABELS_MAPPERS } },
    { CHANGE_STATUS, { STATUS_CHANGE_MAPPERS, UPDATE_LABELS_STATUS_CHANGE_MAPPERS } },
    { RESET_FRESH, { RESET_FRESH_MAPPERS } },
    { TRANSFER, { TRANSFER_MAPPERS } },
});

}
