#pragma once

#include "field.h"
#include <mailpusher/notification.h>

namespace yxiva::mailpusher {

typedef std::vector<field> mapper;
struct notification_mappers
{
    using output_filter = std::function<bool(const notification&, const subscription&)>;

    struct destination destination;
    mapper body;
    mapper keys;
    mapper platform_specific = {};
    string tag = {};
    std::vector<output_filter> output_filters = {};

    bool output(const notification& n, const subscription& s) const
    {
        return std::all_of(output_filters.begin(), output_filters.end(), [&](auto& filter) {
            return filter(n, s);
        });
    }
};

typedef std::map<action, std::vector<notification_mappers>> mappers_collection;
extern const mappers_collection MAPPERS;
extern const mappers_collection PRE_RTEC_3674_MAPPERS;

inline mapper operator+(const mapper& mapper1, const mapper& mapper2)
{
    auto mapper = mapper1;
    mapper.insert(mapper.end(), mapper2.cbegin(), mapper2.cend());
    return mapper;
}

inline mapper operator+(const mapper& source, const field& field)
{
    auto mapper = source;
    mapper.push_back(field);
    return mapper;
}

inline mapper operator+(const field& field, const mapper& mapper)
{
    return mapper + field;
}

/*
 * Merge with rules, defined in mappers
 */
inline json_value apply_mapper(
    const mapper& mapper,
    const event& event,
    const subscription& subscription)
{
    json_value body(json_type::tobject);
    for (auto& field : mapper)
    {
        auto field_value = retrieve_field_value({ event, subscription }, field);
        if (field_value)
        {
            body[field.target] = *field_value;
        }
    }
    return body;
}

inline bool is_supported(action action_type)
{
    return MAPPERS.count(action_type);
}

}