#pragma once

#include <mailpusher/notification.h>
#include <mailpusher/subscription.h>
#include <yxiva/core/filter/parse.h>
#include <yxiva/core/message.h>

namespace yxiva::mailpusher {
namespace {

// Assumes that string_map_json
// is a map of string keys to string values.
inline auto to_map(const json_value& string_map_json)
{
    std::map<string, string> ret;
    for (auto node = string_map_json.members_begin(); node != string_map_json.members_end(); node++)
    {
        ret[string(node.key())] = (*node).to_string();
    }
    return ret;
}

}

inline bool filter_action_is_bright(
    const notification& notification,
    const subscription& subscription)
{
    message fake_message;
    fake_message.operation = notification.operation();
    fake_message.data = to_map(notification.keys);
    filter_set filter_set;
    if (!filter::parse(filter_set, subscription.common()->filter))
    {
        // Assume send_bright.
        return true;
    }
    return filter_set.apply(fake_message) == filter::action::send_bright;
}

inline bool marked_read(const notification& notification, const subscription& /*subscription*/)
{
    return notification.keys["hdr_status"] == "RO";
}

inline bool allowed_fid_type_for_insert(
    const notification& notification,
    const subscription& /*subscription*/)
{
    // https://a.yandex-team.ru/arc/trunk/arcadia/mail/macs/include/macs/data/symbols.h?rev=4378508
    static const std::set<string> ignored_fid_types = { "2", "3", "4", "5", "6", "7", "8", "10" };
    return !ignored_fid_types.count(notification.keys["fid_type"].to_string());
}

// The word "not" is reserved,
// hence the undescore at the end.
template <typename F>
struct not_
{
    not_(F&& f) : f_(std::forward<F>(f))
    {
    }
    template <typename... Args>
    bool operator()(Args&&... args)
    {
        return !f_(std::forward<Args>(args)...);
    }

private:
    std::decay_t<F> f_;
};

}