#pragma once

#include "field.h"

namespace yxiva::mailpusher {

inline auto flags_transformation(const json_value& val)
{
    return status_from_is_mixed(json_decoder<uint64_t>::get(val, 0U));
}

inline auto seen_transformation(const json_value& val)
{
    return is_null(val) ?
        "" :
        mailpusher::status_from_flags(json_decoder<bool>::get(val, false), false, false);
}

inline auto lid_transformation(const json_value& labels)
{
    return join_json(labels);
}

inline auto loc_args_transformation(const json_value& body)
{
    return compose_loc_args(
        body["from"],
        json_decoder<string>::get(body, "subject", ""),
        json_decoder<string>::get(body, "firstline", ""));
}

inline auto hdr_transformation(const json_value& addrs)
{
    return json_value(join_json_addresses(addrs));
}

inline json_value get_loc_arg(const json_value& loc_args, std::size_t index)
{
    if (loc_args.is_array() && loc_args.size() > index)
    {
        return loc_args[index];
    }
    return json_value("");
}

inline json_value alert_title_transformation(const json_value& body)
{
    return get_loc_arg(loc_args_transformation(body), 0);
}

inline auto alert_subtitle_transformation(const json_value& body)
{
    return get_loc_arg(loc_args_transformation(body), 1);
}

inline auto alert_body_transformation(const json_value& body)
{
    return get_loc_arg(loc_args_transformation(body), 2);
}

}