#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"
LOGFILE="/var/log/$QLOUD_APPLICATION/access.log"
ts=$(date +%s)

timetail -n 60 -r '^tskv	tskv_format=xivamesh-access-log	timestamp=.{11}(\d\d:\d\d:\d\d)' $LOGFILE | head -n -1 | \
    awk -F $'\t' -v ts="$ts" '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    /request=/ {
        arr["http.total"]++
        code=0
        time=0
        for (i=1; i <= NF; i++) {
            if ($i ~ /^status_code=/) {
                code = substr($i, 13)
            } else if ($i ~ /^profiler_exec=/) {
                time = substr($i, 15)
            }
        }
        collect_codes(code, "http.codes.total", arr)
        if (code ~ /2../) {
            collect_timings(time, "http.timings.all", arr)
        }
    }

    END {
        for (i in arr) {
            value = arr[i]
            if (i ~ /timings/) value = "["value"]"
            print i, value, ts
        }
    }
'