#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"
LOGFILE="/app/log/access.log"
ts=$(date +%s)

timetail -n 60 -r '^tskv	tskv_format=xivamob-access-log	timestamp=.{11}(\d\d:\d\d:\d\d)' $LOGFILE | head -n -1 | \
    awk -F $'\t' -v ts="$ts" '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    /request=/ {
        metrics["http.total"]++

        code = "unknown"
        service = ""
        request = ""
        push_service = ""
        app = ""
        exec_time = 0

        for (i=1; i <= NF; i++) {
            if ($i ~ /^status_code=/) {
                code = substr($i, 13)
            } else if ($i ~ /^service=/) {
                service = substr($i, 9)
            } else if ($i ~ /^request=/) {
                offset = length("request=") + 1
                end = index($i,"?")
                end = end > 0 ? end - offset : length($i)
                request = substr($i, offset, end)
                gsub("^(/)*","",request)
                gsub("[/]","_",request)
            } else if ($i ~ /^profiler_exec=/) {
                exec_time = substr($i, 15)
            } else if ($i ~ /^push_service=/) {
                push_service = substr($i, 14)
                gsub("[\./:]+", "_", push_service)
            } else if ($i ~ /^app=/) {
                app = substr($i, 5)
                gsub("[\./:]+", "_", app)
            }
        }

        metrics["http.codes.total."code]++
        metrics["http.codes.service_total."code".tier_"service]++
        metrics["http.codes."request"."code".tier_"service]++
        metrics["http.codes.perapp."code".tier_"app]++
        if (push_service) metrics["http.codes.by_provider."request"."push_service"."code".tier_"service]++
        if (code ~ /2../) {
            collect_timings(exec_time, "http.timings.total.tier_"service, metrics)
            collect_timings(exec_time, "http.timings."request".tier_"service, metrics)
        }
    }

    END {
        for (i in metrics) {
            value = metrics[i]
            if (i ~ /timings/) value = "["value"]"
            print i, value, ts
        }
    }
' | awk '
    match($1,/tier_/) {
        tier = substr($1, RSTART+RLENGTH)
        if (tier == "") tier = "none"
        print substr($1,1,RSTART-2), $2, $3, tier
    }
    !/tier_/ {
        print
    }
'