package main

import (
	"fmt"
	"log"
	"net/http"
	"os"
)

func main() {
	const addr = "localhost:9999"

	srv := &http.Server{
		Addr:    addr,
		Handler: http.HandlerFunc(handle),
	}

	log.Printf("Serving on https://%v", addr)
	log.Fatal(srv.ListenAndServeTLS(os.Args[1], os.Args[1]))
}

func handle(w http.ResponseWriter, r *http.Request) {
	log.Printf("%v %v %v", r.Proto, r.Method, r.URL)

	if r.ProtoMajor != 2 {
		log.Printf("unsupported protocol version")
		w.WriteHeader(http.StatusInternalServerError)
		_, err := fmt.Fprintf(w, "unsupported protocol version")
		if err != nil {
			log.Printf("%v", err)
			panic(err)
		}
		return
	}

	w.Header().Add("apns-id", "012MSGID45")
	w.WriteHeader(http.StatusOK)
	log.Printf("OK")
}
