#pragma once

#include <yxiva_mobile/push_task_context.h>
#include <yxiva/core/conf.h>
#include <yxiva/core/json.h>
#include <yxiva/core/types.h>
#include <boost/function.hpp>

namespace yxiva { namespace mobile {

typedef std::function<void(const boost::system::error_code&, json_value, bool)> result_callback_t;

struct callback_t
{
    std::function<void(const boost::system::error_code&, const string&)> cb;

    callback_t() = default;

    template <typename F>
    callback_t(F&& cb) : cb(std::forward<F>(cb))
    {
    }

    void operator()(const boost::system::error_code& code) const
    {
        cb(code, "");
    }

    void operator()(const boost::system::error_code& code, const string& body) const
    {
        cb(code, body);
    }
};

class ipusher
{
public:
    virtual void push(mobile_task_context_ptr ctx, callback_t&& cb) = 0;
    virtual void check(mobile_task_context_ptr ctx, callback_t&& cb) = 0;
    virtual void update_application(const application_config& app) = 0;

    virtual ~ipusher() = default;
};

class batch_pusher : public ipusher
{
public:
    virtual void push_batch(batch_task_context_ptr ctx, result_callback_t&& cb) = 0;
};

}}