#pragma once

#include <map>
#include <atomic>

#include <yxiva/core/types.h>
#include <yxiva/core/json.h>
#include <ymod_webserver/request.h>
#include <yplatform/task_context.h>

namespace yxiva { namespace mobile {

using std::map;

class push_task_context : public yplatform::task_context
{
public:
    unsigned ttl;
    string payload;
    ymod_webserver::request_ptr request;
    string transit_id;

    push_task_context(ymod_webserver::request_ptr req)
        : yplatform::task_context(*req->ctx()), request(req)
    {
    }

    const string& get_name() const override
    {
        static const string name = "mobile-push";
        return name;
    }

    bool is_cancelled() const
    {
        return request->ctx()->is_cancelled();
    }
};

class mobile_task_context : public push_task_context
{
public:
    string app_name;
    string token;
    std::vector<std::pair<string, string>> headers;

    mobile_task_context(ymod_webserver::request_ptr req) : push_task_context(req)
    {
    }
};

class batch_task_context : public push_task_context
{
public:
    string app_name;
    json_value tokens;
    json_value response;

    batch_task_context(ymod_webserver::request_ptr req) : push_task_context(req)
    {
    }
};

class webpush_task_context : public push_task_context
{
public:
    string subscription;

    webpush_task_context(ymod_webserver::request_ptr req) : push_task_context(req)
    {
    }
};

using mobile_task_context_ptr = boost::shared_ptr<mobile_task_context>;
using webpush_task_context_ptr = boost::shared_ptr<webpush_task_context>;
using batch_task_context_ptr = boost::shared_ptr<batch_task_context>;

}}
