#pragma once

#include "settings.h"
#include "senders_pool.h"
#include <yxiva_mobile/error.h>
#include <yxiva_mobile/ipusher.h>
#include <yxiva_mobile/mutex.h>
#include <yxiva/core/packing.hpp>
#include <yplatform/module.h>
#include <map>
#include <memory>

namespace yxiva { namespace mobile { namespace apns {

namespace p = std::placeholders;

class mod
    : public yplatform::module
    , public ipusher
{
public:
    explicit mod(yplatform::reactor& reactor);
    void init(const yplatform::ptree& data);
    void reload(const yplatform::ptree& data);
    yplatform::ptree get_stats() const override;
    void push(mobile_task_context_ptr ctx, callback_t&& cb) override;
    void check(mobile_task_context_ptr ctx, callback_t&& cb) override;
    void update_application(const application_config& app) override;

private:
    operation::result prepare_payload(mobile_task_context_ptr& ctx);
    string detect_push_type(const mobile_task_context_ptr& ctx, const json_value& payload);
    senders_pool::secrets_map read_secrets();
    string read_secret_from_file(const string& filename);
    apns_settings_ptr settings();
    void settings(apns_settings_ptr st);

private:
    yplatform::reactor_ptr reactor_;
    apns_settings_ptr settings_;
    senders_pool senders_;
    shared_mutex guard_;
};

}}}