#pragma once

#include "settings.h"
#include <yxiva_mobile/ipusher.h>
#include <yxiva_mobile/push_task_context.h>
#include <ymod_httpclient/h2/client.h>

#include <utility>

namespace yxiva { namespace mobile { namespace apns {

/*
 * sender is used to send notifications to a single application.
 */
class sender
    : public yplatform::log::contains_logger
    , public std::enable_shared_from_this<sender>
{
public:
    typedef std::pair<string, app_environment> secret;

    sender(const yplatform::log::source& parent_logger);
    virtual ~sender() = default;
    virtual void push(const mobile_task_context_ptr& ctx, callback_t&& cb) = 0;
    virtual const string& secret_type() const = 0;
    virtual yplatform::ptree get_stats() const;

protected:
    boost::system::error_code handle_http_error(
        mobile_task_context_ptr ctx,
        const boost::system::error_code& err);
    boost::system::error_code handle_http_status(
        mobile_task_context_ptr ctx,
        yhttp::response resp,
        string& result_body);
    const string& topic_from_url_params(
        const mobile_task_context_ptr& ctx,
        const string& default_topic) const;

    size_t requests_sent_ = 0;
};

using sender_ptr = std::shared_ptr<sender>;

}}}