#pragma once

#include "sender.h"
#include "settings.h"
#include "p8_bearer.h"

namespace yxiva::mobile::apns {

class sender_p8 : public sender
{
public:
    sender_p8(
        boost::asio::io_service& io,
        const sender::secret& secret,
        const apns_settings& settings,
        const yplatform::log::source& parent_logger);
    void push(const mobile_task_context_ptr& ctx, callback_t&& cb) override;
    const string& secret_type() const override;

private:
    void reconnect();
    boost::system::error_code handle_http_status_p8(
        mobile_task_context_ptr ctx,
        yhttp::response resp,
        string& result_body);

    boost::asio::io_service& io_;
    const ymod_httpclient::h2::settings http2_settings_;
    std::shared_ptr<ymod_httpclient::h2::client> httpclient_;
    string url_;
    p8_token token_;
    p8_bearer bearer_;
};

}
