#include "sender_pem.h"
#include <yxiva/core/platforms.h>

namespace yxiva::mobile::apns {

using namespace yxiva::apns;

sender_pem::sender_pem(
    boost::asio::io_service& io,
    const sender::secret& secret,
    const apns_settings& settings,
    const yplatform::log::source& parent_logger)
    : sender(parent_logger)
{
    auto& [secret_buffer, prefered_type] = secret;

    auto client_settings = settings.http2;
    client_settings.ssl.cert = client_settings.ssl.key = secret_buffer;
    httpclient_ = std::make_shared<ymod_httpclient::h2::client>(io, client_settings);
    httpclient_->logger(logger());

    auto auto_type = pem_certificate::get_type(secret_buffer);
    auto type = prefered_type == app_environment::automatic ?
        auto_type :
        certificate_type_from_env(prefered_type);
    url_ = type == certificate_type::production ? settings.url : settings.sandbox_url;

    topic_ = pem_certificate::get_topic(secret_buffer);
}

void sender_pem::push(const mobile_task_context_ptr& ctx, callback_t&& cb)
{
    ymod_httpclient::h2::headers headers;
    headers.reserve(ctx->headers.size() + 2);
    headers.assign(ctx->headers.begin(), ctx->headers.end());
    headers.emplace_back("apns-topic", topic_from_url_params(ctx, topic_));
    headers.emplace_back(
        "apns-expiration", std::to_string(ctx->ttl ? std::time(nullptr) + ctx->ttl : 0));

    auto request =
        ymod_httpclient::h2::request::POST(url_ + ctx->token, std::move(headers), ctx->payload);
    httpclient_->async_run(
        ctx,
        std::move(request),
        [this, self = shared_from_this(), ctx, cb = std::move(cb)](
            const boost::system::error_code& err, yhttp::response resp) {
            ++requests_sent_;
            string result_body;
            cb(err ? handle_http_error(ctx, err) : handle_http_status(ctx, resp, result_body),
               result_body);
        });
}

const string& sender_pem::secret_type() const
{
    static const string secret_type = "pem";
    return secret_type;
}

}
