#pragma once

#include "sender.h"

namespace yxiva::mobile::apns {

class sender_pem : public sender
{
public:
    sender_pem(
        boost::asio::io_service& io,
        const sender::secret& secret,
        const apns_settings& settings,
        const yplatform::log::source& parent_logger);
    virtual void push(const mobile_task_context_ptr& ctx, callback_t&& cb) override;
    const string& secret_type() const override;

private:
    std::shared_ptr<ymod_httpclient::h2::client> httpclient_;
    string url_;
    string topic_;
};

}
