#pragma once

#include "migration_sender.h"
#include "settings.h"
#include <yxiva_mobile/mutex.h>
#include <yxiva/core/platforms.h>
#include <yxiva/core/iabstract.h>
#include <yplatform/log.h>

namespace yxiva { namespace mobile { namespace apns {

struct secret
{
    secret() = default;
    secret(const string& actual_secret, app_environment actual_env)
        : actual({ actual_secret, actual_env }), backup({ "", app_environment::automatic })
    {
    }

    sender::secret actual;
    sender::secret backup;
    time_t updated_at = 0;
};

/*
 * senders_pool manages apns_sender for each known application.
 * It dynamicaly creates senders for new apps and discards senders
 * for outdated due to certificate removal apps.
 */
class senders_pool
    : public yplatform::log::contains_logger
    , public iabstract
{
protected:
    typedef std::map<string, sender_ptr> senders_map;
    typedef std::shared_ptr<senders_map> senders_map_ptr;

public:
    // Secret data and prefered app environment.
    typedef std::map<string, secret> secrets_map;
    typedef std::shared_ptr<secrets_map> secrets_map_ptr;

    void start(secrets_map secrets, const apns_settings& settings, yplatform::reactor_ptr reactor);
    void update(
        const secrets_map& new_secrets,
        const apns_settings& settings,
        const char* when = "update");
    sender_ptr find_sender(const string& app_name);
    yplatform::ptree get_stats() const;

protected:
    senders_map_ptr pool() const;
    void pool(senders_map_ptr updated);
    secrets_map_ptr known_secrets() const;
    void known_secrets(secrets_map_ptr updated);

private:
    void remove_sender(senders_map_ptr pool, const string& secret_name);
    virtual sender_ptr create_sender(
        const string& secret_name,
        const secret& secret,
        const apns_settings& settings,
        const char* when);
    void handle_pem_to_p8_migration(
        sender_ptr& sender,
        const secret& secret,
        const apns_settings& settings);
    bool pem_valid_during_migration(const string& cert, time_t updated_at, duration duration);

private:
    mutable shared_mutex guard_;
    secrets_map_ptr known_secrets_;
    senders_map_ptr pool_;
    yplatform::reactor_ptr reactor_;
};

}}}