#pragma once

#include <yxiva_mobile/push_task_context.h>
#include <yxiva_mobile/ipusher.h>
#include <ymod_httpclient/request.h>

namespace yxiva { namespace mobile { namespace fcm {

#define FCM_MAX_DATA_LENGTH 4 * 1024         // 4 Kb
#define FCM_MAX_NOTIFICATION_LENGTH 2 * 1024 // 2 Kb

struct request_param
{
    string name;
    json_type type;
    std::size_t max_length;

    request_param(string _name, json_type _type, std::size_t len = FCM_MAX_DATA_LENGTH)
        : name(std::move(_name)), type(_type), max_length(len)
    {
    }
};

template <typename Task, typename Callback>
struct fcm_request_base
{
    Task task;
    yhttp::request http_request;
    Callback cb;

    fcm_request_base(Task&& _task, yhttp::request&& _http_request, Callback&& cb)
        : task(std::move(_task)), http_request(std::move(_http_request)), cb(std::move(cb))
    {
    }
};

struct fcm_push_request : fcm_request_base<mobile_task_context_ptr, callback_t>
{
    template <typename... Args>
    fcm_push_request(Args&&... args) : fcm_request_base(std::forward<Args>(args)...)
    {
    }
};

struct fcm_push_batch_request : fcm_request_base<batch_task_context_ptr, result_callback_t>
{
    template <typename... Args>
    fcm_push_batch_request(Args&&... args) : fcm_request_base(std::forward<Args>(args)...)
    {
    }
};

struct fcm_check_request : fcm_request_base<mobile_task_context_ptr, callback_t>
{
    template <typename... Args>
    fcm_check_request(Args&&... args) : fcm_request_base(std::forward<Args>(args)...)
    {
    }
};

using fcm_push_request_ptr = std::shared_ptr<fcm_push_request>;
using fcm_push_batch_request_ptr = std::shared_ptr<fcm_push_batch_request>;
using fcm_check_request_ptr = std::shared_ptr<fcm_check_request>;

}}}
