#pragma once

#include <ymod_httpclient/request.h>
#include <yxiva_mobile/reports.h>

namespace yxiva { namespace mobile { namespace fcm {

struct http_pusher_settings
{
    string host_push;
    string url_push;
    string host_check;
    string url_check;
    yhttp::options http_opts;
    std::map<string, string> api_keys;
    bool dump_payload = false;

    void load(const yplatform::ptree& conf)
    {
        host_push = conf.get<string>("host_push");
        url_push = conf.get<string>("url_push");
        host_check = conf.get<string>("host_check");
        url_check = conf.get<string>("url_check");
        http_opts.reuse_connection = conf.get("keep_alive", true);

        if (auto keys = conf.get_child_optional("api-keys"))
        {
            for (auto& node : keys.get())
            {
                report_fcm_api_key_found(task_context::fake(), "start", node.first);
                api_keys[node.first] = node.second.get_value<string>();
            }
        }

        dump_payload = conf.get("dump_payload", dump_payload);
    }
};

}}}
