#pragma once

#include "settings.h"
#include "push_impl.h"
#include <yxiva/core/request_stats.h>
#include <yplatform/module.h>

namespace yxiva { namespace mobile { namespace web {

class impl : public yplatform::module
{
public:
    void init(const yplatform::ptree& xml);

protected:
    yplatform::ptree get_stats() const override
    {
        yplatform::ptree result;
        result.put_child("mobile", request_stats_->to_ptree());
        result.put_child("webpush", request_stats_webpush_->to_ptree());
        return result;
    }

private:
    settings_ptr settings_;
    std::shared_ptr<mobile_proxy> fcm_proxy;
    std::shared_ptr<batch_proxy> fcm_batch_proxy;
    std::shared_ptr<mobile_proxy> apns_proxy;
    std::shared_ptr<mobile_proxy> wns_proxy;
    std::shared_ptr<mobile_proxy> mpns_proxy;
    std::shared_ptr<mobile_proxy> hms_proxy;
    std::shared_ptr<::yxiva::mobile::web::webpush_proxy> webpush_proxy;
    std::shared_ptr<request_stats> request_stats_;
    std::shared_ptr<request_stats> request_stats_webpush_;
};

}}}
