#pragma once

#include <yxiva/core/types.h>
#include <yplatform/time_traits.h>
#include <boost/date_time/posix_time/posix_time.hpp>
#include <map>

namespace yxiva { namespace mobile { namespace web {

struct settings
{
    typedef yplatform::time_traits::duration duration_type;
    typedef yplatform::time_traits::nanoseconds nanoseconds;

    std::map<string, duration_type> total_timeouts;
    unsigned max_ttl;
    unsigned rps_limit;
    unsigned rps_limit_webpush;

    void load(const yplatform::ptree& conf)
    {
        for (auto& node : conf.get_child("timeouts"))
        {
            auto duration = node.second.get_value<boost::posix_time::time_duration>();
            total_timeouts[node.first] = nanoseconds(duration.total_nanoseconds());
        }
        max_ttl = conf.get("max_ttl", 604800U);
        rps_limit = conf.get<unsigned>("rps_limit", 9000);
        rps_limit_webpush = conf.get<unsigned>("rps_limit_webpush", 9000);
    }

    duration_type get_timeout(const char* service)
    {
        auto itimeout = total_timeouts.find(service);
        if (itimeout == total_timeouts.end())
            throw std::runtime_error(string("timeout for '") + service + "' not set");
        return itimeout->second;
    }
};

typedef shared_ptr<settings> settings_ptr;

}}}
