PY2TEST()



OWNER(g:xiva)

SET(RECIPE_CONFIG_FILE mail/xiva/mobile/tests-system/recipe-config.yml)
SET(DOCKER_COMPOSE_FILE mail/xiva/mobile/tests-system/docker-compose.yml)
INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

PEERDIR(
    contrib/python/nose
    contrib/python/PyHamcrest
    mail/xiva/core
)

TAG(
    ya:external
    ya:fat
    ya:force_sandbox
    ya:nofuse
)

REQUIREMENTS(
    container:1435059545 # xenial
    cpu:all
    dns:dns64
    network:full
)

ENV(XTEST_HOST=localhost)
ENV(XTEST_PORT=12080)

TEST_SRCS(
    conftest.py
    apns/send_p8.py
    apns/send_p8_with_parameters.py
    apns/send_pem.py
    apns/send_pem_with_parameters.py
    apns/send_pem_to_p8.py
    apns/send_pem_to_p8_with_parameters.py
    fcm/batch.py
    fcm/check.py
    fcm/fcm_response.py
    fcm/send.py
    fcm/send_with_parameters.py
    hms/send.py
    webpush/send.py
    webpush/send_check.py
    webpush/send_params.py
    windows/mpns_send.py
    windows/mpns_send_check.py
    windows/mpns_send_multistatus.py
    windows/wns_send.py
    windows/wns_send_check.py
    windows/wns_send_multistatus.py
)

RESOURCE_FILES(
    mail/xiva/mobile/tests-system/fcm/batch.json
)

DATA(
    arcadia/mail/xiva/core/pycommon
    arcadia/mail/xiva/mobile/deploy
    arcadia/mail/xiva/mobile/config
    arcadia/mail/xiva/mobile/tests-system
    arcadia/mail/xiva/mobile/Dockerfile
    arcadia/mail/xiva/mobile/fake_apns_server/cert.pem
)

DEPENDS(
    mail/xiva/mobile
    mail/xiva/mobile/fake_apns_server
)

END()
