package com.huawei.hmssample;

import com.huawei.logger.Log;

import com.huawei.hms.push.HmsMessageService;
import com.huawei.hms.push.RemoteMessage;

public class YourHmsMessageService extends HmsMessageService {
    public static final String TAG = "HmsMessageService";

    @Override
    public void onNewToken(String token) {
        Log.d(TAG, "Refreshed token: " + token);
    }

    @Override
    public void onMessageReceived(RemoteMessage message) {
        Log.i(TAG, "onMessageReceived is called");

        if (message.getData().length() > 0) {
            Log.d(TAG, "Message data payload: " + message.getData());
            if (/* This method callback must be completed within 10s. */ true) {
                /* Otherwise, you need to start a new job for callback processing. */
                startNewJobProcess();
            } else {
                // Process message within 10s
                processNow();
            }
        }
        // Check if this message contains a notification payload.
        if (message.getNotification() != null) {
            Log.d(TAG, "Message Notification Body: " + message.getNotification().getBody());
        }
        // TODO: your's other processing logic
    }
    private void startNewJobProcess() {
        Log.d(TAG, "Start new job processing.");
        //TODO:
    }
    private void processNow() {
        Log.d(TAG, "Processing now.");
    }
}
