#pragma once

#include <boost/bind.hpp>

namespace pipeline {

/**
 * CommitListener is supposed to listed consumed from stream data.
 * It connects to the last stream in pipeline via commit handler.
 */
template <typename StreamT>
class CommitListener : public std::enable_shared_from_this<CommitListener<StreamT>>
{
protected:
    typedef typename StreamT::this_ptr stream_ptr;
    typedef typename StreamT::temp_collection_ptr collection_ptr;

public:
    CommitListener()
    {}

    virtual ~CommitListener()
    {}

    stream_ptr input() { return input_; }
    void input(stream_ptr in)
    {
        input_ = in;
    }

    virtual void start()
    {
        assert(input_);
        input_->reset_commit_handler(boost::bind(&CommitListener::on_commit, this->shared_from_this(), _1));
    }

    virtual void stop()
    {
        assert(input_);
        input_->reset_commit_handler();
    }

protected:
    virtual void on_commit(collection_ptr committed_range) = 0;

private:
    stream_ptr input_;
};

}
