#pragma once

#include <string>

#include <boost/date_time/posix_time/posix_time.hpp>

//#define SIMPLE_RAII_PROFILER(obj, func) profiler profiler_instance(obj, func);
#define SIMPLE_RAII_PROFILER(obj, func)

namespace pipeline {

struct profiler
{
    profiler(const std::string& object_name, const std::string& function_name)
    : start(boost::posix_time::microsec_clock::universal_time()),
      object_name(object_name),
      function_name(function_name)
    {}

    ~profiler()
    {
        boost::posix_time::ptime end = boost::posix_time::microsec_clock::universal_time();
        boost::posix_time::time_duration diff = end - start;
        YLOG_G(debug) << "[" << object_name << "]." << function_name << " duration " << diff.total_microseconds();
    }

    const boost::posix_time::ptime start;
    const std::string object_name, function_name;
};


}
