#pragma once

namespace pipeline {

struct StreamSettings
{
    std::size_t capacity;
    std::size_t window;
    std::size_t grouped_flush_size;

    StreamSettings(std::size_t _capacity = 100U)
    : capacity(_capacity), window(_capacity), grouped_flush_size(1)
    {}

    StreamSettings& set_window(std::size_t _window)
    {
        window = _window > capacity ? capacity : _window;
        return *this;
    }

    StreamSettings& set_grouped_flush_size(std::size_t size)
    {
        grouped_flush_size = size > 0 ? size : 1;
        return *this;
    }
};

}
