#!/usr/bin/env python
from pprint import pprint
import re

import nginxparser_eb as ngx


__manual_upstreams_file__ = '/usr/local/etc/xivahub-manual-upstreams' 

def replace_placeholder(proxy_url):
    proxy_url = re.sub(r'^(http://).*_hub-shard-placeholder(.*)$',
                       r'\1$xivahub_shard',
                       proxy_url,
                       count=1)
    return proxy_url

def patch_config(qloud_config):
    conf = ngx.loads(qloud_config)
    try:
        with open(__manual_upstreams_file__, 'r') as f:
            manual_conf = ngx.loads(f.read())
    except:
        manual_conf = []
    # Add/replace qloud upstreams
    for manual_block in manual_conf:
        if 'upstream' in manual_block[0]:
            # replace if possible
            replaced = False
            for block in conf:
                if 'upstream' in block[0] and block[0][1] == manual_block[0][1]:
                    block[1] = manual_block[1]
                    replaced = True
            # add if not replaced
            if not replaced:
                conf.insert(0, manual_block)
    for block in conf:
        if block[0] == ['server'] \
                and (['server_name', 'xivahub-sandbox.mail.yandex.net'] in block[1]\
                  or ['server_name', 'xivahub-tst.mail.yandex.net'    ] in block[1]\
                  or ['server_name', 'xivahub.mail.yandex.net'        ] in block[1]\
                  or ['server_name', 'xivahubcorp.mail.yandex.net'    ] in block[1]\
                  or ['server_name', 'xivahubyamb-tst.mail.yandex.net'] in block[1]\
                  or ['server_name', 'xivahubyamb.mail.yandex.net'    ] in block[1]):
            for subblock in block[1]:
                # only location blocks
                if subblock[0] and subblock[0][0] \
                        and subblock[0][0] == 'location':
                    # some locations shuld be distributed evenly across shards
                    if subblock[0][1] == '/batch_binary_notify':
                        subblock[1].insert(0, ngx.loads('set $random_shard "1";')[0])
                    # itetate over all lines in location {}
                    for loc_block in subblock[1]:
                        # replace placeholder nodes with shard-generated ones
                        if loc_block[0] == 'proxy_pass':
                            loc_block[1] = replace_placeholder(loc_block[1])
    return ngx.dumps(conf)

