#!/usr/bin/env python
from pprint import pprint
import re

import nginxparser_eb as ngx


def create_manual_upstreams(qloud_config_filename,
                            new_config_suffix,
                            orig_port,
                            new_port):
    conf = ngx.load(open(qloud_config_filename, 'r'))
    new_conf = ngx.loads('#generated by /usr/sbin/xivapatcher.py\n')
    for block in conf:
        if 'upstream' in block[0] and block[0][1].startswith('mail_xiva-server_'):
            print(block)
            new_upstream = block
            new_upstream[0][1] = new_upstream[0][1] + new_config_suffix
            print(new_upstream)
            for line in new_upstream[1]:
                if line[0] == 'server':
                    line[1] = re.sub(r'^(\S+):{} (.*)'.format(orig_port),
                                     r'\1:{} \2'.format(new_port),
                                     line[1])
            new_conf.append(new_upstream)
    return ngx.dumps(new_conf)

