#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"
LOGFILE="/var/log/$QLOUD_APPLICATION/access.log"
ts=$(date +%s)

timetail -n 60 -r '^tskv	tskv_format=reaper-access-log	timestamp=.{11}(\d\d:\d\d:\d\d)' "$LOGFILE" | head -n -1 | \
    awk -F $'\t' -v ts="$ts" '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    /request=/ {
        metrics["http.total"]++

        code = "unknown"
        request = ""
        exec_time = 0

        for (i=1; i <= NF; i++) {
            if ($i ~ /^status_code=/) {
                code = substr($i, 13)
            } else if ($i ~ /^request=/) {
                pos = index($i,"?")
                request = (pos == 0) ? request = substr($i, 9) : substr($i, 9, pos-9)
                gsub("^(/)*","",request)
                gsub("[/]","_",request)
            } else if ($i ~ /^profiler_exec=/) {
                exec_time = substr($i, 15)
            }
        }

        metrics["http.codes.total."code]++
        metrics["http.codes."request"."code]++

        if (code ~ /2../) {
            collect_timings(exec_time, "http.timings.total", metrics)
            collect_timings(exec_time, "http.timings."request, metrics)
        }
    }

    END {
        for (i in metrics) {
            value = metrics[i]
            if (i ~ /timings/) value = "["value"]"
            print i, value, ts
        }
    }
'
