#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"
LOGFILE="/var/log/$QLOUD_APPLICATION/typed.log"
ts=$(date +%s)

timetail -n 60 -r '^tskv	tskv_format=xivareaper-log	timestamp=.{11}(\d\d:\d\d:\d\d)' "$LOGFILE" | head -n -1 | \
    awk -F $'\t' -v ts="$ts" '
    /status=/ {
        status = ""
        service = ""
        event = ""

        for (i=1; i <= NF; i++) {
            if ($i ~ /^status=/) {
                status = substr($i, 8)
                gsub("(_|,| |-)", "", status)
            } else if ($i ~ /^service=/) {
                service = substr($i, 9)
                gsub("(_|,| |-)", "", service)
            } else if ($i ~ /^event=/) {
                event = substr($i, 7)
                gsub("(_|,| |-)", "", event)
            }
        }

        if (status != "") metrics["events.by_status."status".total"]++
        if (event != "") {
            gsub("\\.", "_", event)
            metrics["events.by_status."status"."event]++
        }
        if (status == "unsubscribed" || service != "") {
            metrics["events.by_service."status".tier_"service]++
        }
    }

    END {
        for (i in metrics) {
            print i, metrics[i], ts
        }
    }
' | awk '
    match($1,/tier_/) {
        tier = substr($1, RSTART+RLENGTH)
        if (tier == "") tier = "none"
        print substr($1,1,RSTART-2), $2, $3, tier
    }
    !/tier_/ {
        print
    }
'
