#include "extractor.h"

namespace yxiva {
namespace reaper {

using namespace field_codes;

const string EMPTY;
constexpr std::initializer_list<const char*> keys_str = {
  "uid",
  "name",
  "connection_id",
  "url",
  "id",
  "connection_id",
  "service"
};
constexpr std::initializer_list<const char*> keys_num = {
  "timestamp",
  "init_time",
};

static_assert(keys_str.size() == strings_count,
  "string keys count must match field count");
static_assert(keys_num.size() == numbers_count,
  "numeric keys count must match field count");
const std::vector<const char*> string_field_keys(keys_str);
const std::vector<const char*> number_field_keys(keys_num);

bool has_field(const json_value& val, strings field)
{
  if (field >= strings_count) {
    throw std::runtime_error("field index out of bound");
  }
  auto key = string_field_keys[field];
  return val.has_member(key) && val[key].is_string()
    && val[key].to_string_view().size();
}

bool has_field(const json_value& val, numbers field)
{
  if (field >= numbers_count) {
    throw std::runtime_error("field index out of bound");
  }
  auto key = number_field_keys[field];
  return val.has_member(key) && val[key].is_number();
}

string get_field(const json_value& val, strings field)
{
  if (field >= strings_count) {
    throw std::runtime_error("field index out of bound");
  }
  return json_get<string>(val, string_field_keys[field], EMPTY);
}

uint64_t get_field(const json_value& val, numbers field)
{
  if (field >= numbers_count) {
    throw std::runtime_error("field index out of bound");
  }
  return json_get<uint64_t>(val, number_field_keys[field], 0);
}

}}
