#pragma once

#include <yxiva/core/json.h>
#include <yxiva/core/iabstract.h>

namespace yxiva {
namespace reaper {

namespace field_codes {
enum strings
{
  event_uid,
  event_name,
  event_connection_id,
  sub_url,
  sub_id,
  sub_connection_id,
  sub_service,
  strings_count
};
enum numbers
{
  event_timestamp,
  sub_init_time,
  numbers_count
};
}

bool has_field(const json_value& val, field_codes::strings field);
bool has_field(const json_value& val, field_codes::numbers field);
string get_field(const json_value& val, field_codes::strings field);
uint64_t get_field(const json_value& val, field_codes::numbers field);

}}
