#pragma once

#include <yxiva/core/types.h>

namespace yxiva {
namespace reaper {

struct settings
{
  string batch_binary_notify_url;
  string list_url;
  string unsubscribe_url;
  unsigned notify_max_attempts;
  bool use_configured_service_list;

  void read_config(const yplatform::ptree& conf)
  {
    batch_binary_notify_url = conf.get<string>("batch_binary_notify_url");
    list_url = conf.get<string>("list_url");
    unsubscribe_url = conf.get<string>("unsubscribe_url");
    if (!(notify_max_attempts = conf.get<unsigned>("notify_max_attempts"))) {
      throw std::runtime_error("notify_max_attempts can't be less than 1");
    }

    use_configured_service_list = conf.get<bool>("use_configured_service_list", false);
  }
};

using settings_ptr = std::shared_ptr<settings>;

inline std::shared_ptr<std::vector<string>> read_services(const yplatform::ptree& conf)
{
  auto services = std::make_shared<std::vector<string>>();
  auto service_list = conf.get_child("services");
  for (auto& service_node: service_list) {
    if (service_node.first == "list") {
      auto service = service_node.second.get_value<string>();
      if (service.empty()) {
        throw std::runtime_error("bad settings - empty service name");
      }
      services->push_back(service);
    }
  }
  if (services->empty()) {
    throw std::runtime_error("empty list of services");
  }
  // Service list is sorted for convenience.
  std::sort(services->begin(), services->end());
  return services;
}


}}
